#include "AT24C512C.h"

/*
   AT24C512C.cpp
   
   Test board： INHAOS DUE Core
   http://www.inhaos.com/product_info.php?products_id=164
   
*/

AT24C512C::AT24C512C(void)
{
   Wire.begin();
}

void AT24C512C::write(unsigned long dataAddress, uint8_t data)
{

   Wire.beginTransmission((uint8_t)((0x500000 | dataAddress) >> 16)); // B1010xxx
   Wire.write((uint8_t)((dataAddress & WORD_MASK) >> 8)); // MSB
   Wire.write((uint8_t)(dataAddress & 0xFF)); // LSB
   Wire.write(data);
   Wire.endTransmission();
   delay(5);
}

uint8_t AT24C512C::read(unsigned long dataAddress)
{
   uint8_t data = 0x00;
   Wire.beginTransmission((uint8_t)((0x500000 | dataAddress) >> 16)); // B1010xxx
   Wire.write((uint8_t)((dataAddress & WORD_MASK) >> 8)); // MSB
   Wire.write((uint8_t)(dataAddress & 0xFF)); // LSB
   Wire.endTransmission();
   Wire.requestFrom(0x50 | (dataAddress >> 16), 1);
   if (Wire.available()) data = Wire.read();
   return data;
}

void AT24C512C::write_block(uint8_t *pbuf, unsigned long dataAddress, uint8_t len)
{
	uint8_t i;

	uint8_t *p = pbuf;

	for(i = 0; i < len; i++) {
		write(dataAddress+i, *p++);
	}
}

void AT24C512C::read_block(uint8_t *pbuf, unsigned long dataAddress, uint8_t len)
{
	uint8_t i;

	uint8_t *p = pbuf;

	for(i = 0; i < len; i++) {
		*p++ = read(dataAddress+i);
	}
}

void AT24C512C::write32(unsigned long dataAddress, uint32_t value)
{
	uint8_t i;
	uint8_t data = 0;
	uint32_t dwTmp = value;

	for(i = 0; i < 4; i++) {
		data = dwTmp & 0xFF;
		write(dataAddress+i, data);
		dwTmp>>=8;
	}
}

uint32_t AT24C512C::read32(unsigned long dataAddress)
{
	uint8_t i;

	uint32_t drTmp = 0;

	for(i = 0; i < 4; i++) {
		//drTmp <<=8;
		drTmp |= (read(dataAddress+i)) << (8*i);
	}
	return drTmp;
}


AT24C512C EEPROM512;
