#ifndef AT24C512C_h
#define AT24C512C_h

/*
  AT24C512C Library for Arduino
  
  Test board INHAOS DUE Core
  http://www.inhaos.com/product_info.php?products_id=164
  
*/

#include <Arduino.h>
#include <Wire.h>

#define FULL_MASK 0x7FFFF
#define DEVICE_MASK 0x7F0000
#define WORD_MASK 0xFFFF

class AT24C512C
{
  public:
	AT24C512C();
    static void write(unsigned long, uint8_t);
    static uint8_t read(unsigned long);
	static void write_block(uint8_t *, unsigned long, uint8_t );
	static void read_block(uint8_t *, unsigned long, uint8_t );
	static void write32(unsigned long, uint32_t value);
	static uint32_t read32(unsigned long);	
};

extern AT24C512C EEPROM512;

#endif
