/*
   EEPROM512_BlockOperation.ino
   
   Test board： INHAOS DUE Core
   http://www.inhaos.com/product_info.php?products_id=164
   
*/

#include <Wire.h>
#include <AT24C512C.h>

unsigned long Time;
unsigned long finishTime;
unsigned long errors = 0;
unsigned long address = 0;
byte loop_size;

// Set to a higher number if you want to start at a higher address. 
#define MIN_ADDRESS 0

// Maximum address (inclusive) in address space.  Choose one.
// It should be: 0x000XFFFF Where X is 0-7 for 1 to 8 devices

#define MAX_ADDRESS 0x0000FFFF // 1 device

unsigned char Date[10] = {0,1,2,3,4,5,6,7,8,9};
unsigned char R_Date[10] = {0};

uint8_t P_WDate[128] = {0};
uint8_t P_RDate[128] = {0};

void setup()
{

  int i = 0;
  uint32_t W_Value = 12345678;
  uint32_t R_Value = 0;
  // Make sure we aren't reading old data
  randomSeed(analogRead(0));
  loop_size = random(1, 100);
  Serial.begin(115200);
  Serial.println();
  Serial.println("AT24C512C Library Benchmark Sketch");
  Serial.println();

  EEPROM512.write_block(Date,0,10);
  EEPROM512.read_block(R_Date,0,10);
  
  Serial.print("R_Date : ");
  for( i = 0; i<10 ;i++)
  {
    Serial.print(R_Date[i]);
    Serial.print(",");
  }
  Serial.println();

  EEPROM512.write32(11,W_Value);
  R_Value = EEPROM512.read32(11);
  Serial.print("R_Value : ");
  Serial.print(R_Value);
  Serial.println();

  Serial.print("P_WDate : ");
  for(i=0;i<128;i++)
  {
     P_WDate[i] = i+3;
     Serial.print(P_WDate[i]);
     Serial.print(",");
  }
  Serial.println();
  
  EEPROM512.write_block(P_WDate,2*128,128);
  EEPROM512.read_block(P_RDate,2*128,128);
  
  Serial.print("P_RDate : ");
  for(i=0;i<128;i++)
  {
    Serial.print(P_RDate[i]);
    Serial.print(",");
  }
  Serial.println();

}

void loop()
{
}
